#include <iostream>
#include <cstdio>
#include <cmath>
#include <vector>
#include <string>
#include <map>
#include <set>
#include <algorithm>

using namespace std;

const int MAXN = 2005;
int tin[MAXN], t;
char used[MAXN];
vector< pair<int, int> > g[MAXN];
set<int> st[MAXN];
int ans, br;

void dfs(int v, int p) {
    used[v] = true;
    tin[v] = t;
    st[v].insert(t++);
    for(size_t i = 0; i < g[v].size(); i++) {
        int u = g[v][i].first, id = g[v][i].second;
        if(id == p)
            return;
        if(used[u]) {
            st[v].insert(tin[u]);
        }
        else {
            dfs(u, id);
            set<int>::iterator it = st[u].upper_bound(tin[v]);
            if(it == st[u].begin())
                br++;
            else {
                it--;
                if(it == st[u].begin())
                    ans++;
            }
            for(set<int>::iterator it = st[u].begin(); it != st[u].end(); it++)
                st[v].insert(*it);
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    int n, m;
    cin >> n >> m;
    for(int i = 0; i < m; i++) {
        int v, u;
        cin >> v >> u;
        v--;
        u--;
        g[v].push_back(make_pair(u, i));
        g[u].push_back(make_pair(v, i));
    }
    dfs(0, -1);
    cout << ans + br * (2 * n - br - 1) / 2 << '\n';
    return 0;
}
